function wh = importWheels(dataFile)
arguments
    dataFile string = [];
end

if isempty(dataFile)
    [dataFile, path] = uigetfile({'*.xlsx;*.xls',...
        'Excel Spreadsheet (*.xlsx,*.xls)';
        '*.*',  'All Files (*.*)'}, ...
        'Select a File');
    dataFile = fullfile(path, dataFile);
end
[~, dataFileName] = fileparts(dataFile);

% Read main parameters from the "main" sheet
rawdata = readcell(dataFile);
rawdata = cell2table(rawdata(2:end, 2:end), 'VariableNames', rawdata(1, 2:end), 'RowNames', rawdata(2:end, 1));

wh.shortName = dataFileName;
wh.fullName = rawdata.value{'Full name'}; % kg
wh.inertia = rawdata.value{'Moment of inertia'}; % kg*m^2
wh.radius = rawdata.value{'Radius'}; % m
wh.mass = rawdata.value{'Mass'}; % kg

end